/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePortionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableStairShapeData;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.StairShape;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePortionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeStairShapeData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={BlockStairs.class})
public abstract class BlockStairsMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.impl$getStairShapeFor(blockState), (Object)this.impl$getPortionTypeFor(blockState), (Object)this.impl$getDirectionalData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableStairShapeData.class.isAssignableFrom(immutable) || ImmutablePortionData.class.isAssignableFrom(immutable) || ImmutableDirectionalData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableStairShapeData) {
            BlockStairs.EnumShape stairShapeType = (BlockStairs.EnumShape)((ImmutableStairShapeData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)stairShapeType));
        }
        if (manipulator instanceof ImmutablePortionData) {
            PortionType portionType = (PortionType)((ImmutablePortionData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)this.impl$convertType((BlockSlab.EnumBlockHalf)portionType)));
        }
        if (manipulator instanceof ImmutableDirectionalData) {
            Direction dir = Constants.DirectionFunctions.checkDirectionToHorizontal((Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get()));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)Constants.DirectionFunctions.getFor(dir)));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.STAIR_SHAPE)) {
            BlockStairs.EnumShape stairShapeType = (BlockStairs.EnumShape)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)stairShapeType));
        }
        if (key.equals(Keys.PORTION_TYPE)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)this.impl$convertType((BlockSlab.EnumBlockHalf)value)));
        }
        if (key.equals(Keys.DIRECTION)) {
            Direction dir = Constants.DirectionFunctions.checkDirectionToHorizontal((Direction)((Object)value));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)Constants.DirectionFunctions.getFor(dir)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private ImmutableStairShapeData impl$getStairShapeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeStairShapeData.class, (StairShape)((Object)blockState.func_177229_b((IProperty)BlockStairs.field_176310_M)));
    }

    private ImmutablePortionData impl$getPortionTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePortionData.class, this.impl$convertType((BlockStairs.EnumHalf)blockState.func_177229_b((IProperty)BlockStairs.field_176308_b)));
    }

    private ImmutableDirectionalData impl$getDirectionalData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{Constants.DirectionFunctions.getFor((EnumFacing)blockState.func_177229_b((IProperty)BlockStairs.field_176309_a))});
    }

    private PortionType impl$convertType(BlockStairs.EnumHalf type) {
        return (PortionType)BlockSlab.EnumBlockHalf.valueOf((String)type.func_176610_l().toUpperCase());
    }

    private BlockStairs.EnumHalf impl$convertType(BlockSlab.EnumBlockHalf type) {
        return BlockStairs.EnumHalf.valueOf((String)type.func_176610_l().toUpperCase());
    }
}

