/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.category.ExploitCategory;
import org.spongepowered.common.config.type.GlobalConfig;

public class ExploitPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Function<ExploitCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"AssuredChangesMarkedDirty", ExploitCategory::changedChunksAlwaysSave).put((Object)"ChunkLoadOnPositionSet", ExploitCategory::chunkLoadOnPosition).put((Object)"ProcessChunkOnMove", ExploitCategory::chunkRefreshOnMove).put((Object)"LimitBookSize", ExploitCategory::limitBookSize).put((Object)"PlayerVehiclesSyncPatch", ExploitCategory::playerSyncVehicle).put((Object)"ItemNameOverflowPrevention", ExploitCategory::isPreventItemNameOverflow).put((Object)"FilterInvalidEntities", ExploitCategory::chunkSaveFiltersEntities).put((Object)"SlotAndSizeFix", ExploitCategory::checkSlotOrSizeDuringWindowClicks).put((Object)"SpamSlotClicksFix", ExploitCategory::checkSlotClickCounts).put((Object)"JNDIChatMessageBlock", ExploitCategory::isBlockHarmfulChatMessage).put((Object)"H2JNDIPatch", ExploitCategory::isBlockH2JndiExploit).build();

    @Override
    public void onLoad(String mixinPackage) {
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String[] className = mixinClassName.split("_");
        String end = className[className.length - 1];
        GlobalConfig globalConfig = SpongeImpl.getGlobalConfigAdapter().getConfig();
        if (globalConfig.getModules().useExploitPatches()) {
            Function<ExploitCategory, Boolean> function = mixinEnabledMappings.get(end);
            if (function == null) {
                new PrettyPrinter(50).add("Could not find function for exploit patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return function.apply(globalConfig.getExploits());
        }
        return false;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

