/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.chat;

import java.util.Locale;
import java.util.Optional;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.SpongeTexts;

public final class ChatUtil {
    public static final String JNDI_EXPLOIT_FRAGMENT = "${jndi";

    private ChatUtil() {
    }

    public static boolean isExploitable(Object message) {
        if (message instanceof String) {
            return ChatUtil.isExploitable((String)message);
        }
        if (message instanceof ITextComponent) {
            return ChatUtil.isExploitable((ITextComponent)message);
        }
        return false;
    }

    public static boolean isExploitable(ITextComponent message) {
        return ChatUtil.isExploitable(message.func_150260_c());
    }

    public static boolean isExploitable(String message) {
        return message.toLowerCase(Locale.ROOT).contains(JNDI_EXPLOIT_FRAGMENT);
    }

    public static void sendMessage(ITextComponent component, MessageChannel channel, CommandSource source, boolean isChat) {
        if (ChatUtil.isExploitable(component.func_150260_c())) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("chat.cannotSend", new Object[0]);
            textcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.RED);
            source.sendMessage(SpongeTexts.toText((ITextComponent)textcomponenttranslation));
            return;
        }
        Text raw = SpongeTexts.toText(component);
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter(raw);
        boolean isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        Cause cause = isMainThread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), source);
        MessageChannelEvent event = isChat ? SpongeEventFactory.createMessageChannelEventChat(cause, channel, Optional.of(channel), formatter, raw, false) : SpongeEventFactory.createMessageChannelEvent(cause, channel, Optional.of(channel), formatter, false);
        if (!SpongeImpl.postEvent(event) && !event.isMessageCancelled() && event.getChannel().isPresent()) {
            event.getChannel().get().send(source, event.getMessage(), isChat ? ChatTypes.CHAT : ChatTypes.SYSTEM);
        }
    }
}

