/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.common.util.VecHelper;

public class RoofedForestPopulator
implements Forest {
    private WeightedTable<PopulatorObject> trees = new WeightedTable();
    private Function<Location<Extent>, PopulatorObject> override = null;

    public RoofedForestPopulator() {
        this.trees.add(BiomeTreeTypes.CANOPY.getPopulatorObject(), 12.6);
        this.trees.add(BiomeTreeTypes.OAK.getPopulatorObject(), 5.1);
        this.trees.add(BiomeTreeTypes.BIRCH.getPopulatorObject(), 1.3);
        this.trees.add(MushroomTypes.BROWN.getPopulatorObject(), 0.5);
        this.trees.add(MushroomTypes.RED.getPopulatorObject(), 0.5);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.FOREST;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        BlockPos pos = new BlockPos(min.getX(), min.getY(), min.getZ());
        World world = (World)worldIn;
        PopulatorObject tree = BiomeTreeTypes.CANOPY.getPopulatorObject();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                int x0 = x * 4 + 1 + random.nextInt(3);
                int z0 = z * 4 + 1 + random.nextInt(3);
                BlockPos blockpos1 = world.func_175672_r(pos.func_177982_a(x0, 0, z0));
                if (this.override != null) {
                    Location<Extent> pos2 = new Location<Extent>(extent, VecHelper.toVector3i(blockpos1));
                    tree = this.override.apply(pos2);
                } else {
                    List<PopulatorObject> results = this.trees.get(random);
                    if (results.isEmpty()) continue;
                    tree = results.get(0);
                }
                if (!tree.canPlaceAt(worldIn, blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p())) continue;
                tree.placeObject(worldIn, random, blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            }
        }
    }

    @Override
    public VariableAmount getTreesPerChunk() {
        return VariableAmount.fixed(16.0);
    }

    @Override
    public void setTreesPerChunk(VariableAmount count) {
    }

    @Override
    public WeightedTable<PopulatorObject> getTypes() {
        return this.trees;
    }

    @Override
    public Optional<Function<Location<Extent>, PopulatorObject>> getSupplierOverride() {
        return Optional.ofNullable(this.override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, PopulatorObject> override) {
        this.override = override;
    }
}

